<?php
$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require '../backend/db.php';
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm = $_POST['confirm'];
    if ($password !== $confirm) {
        $error = 'Passwords do not match.';
    } else {
        $stmt = $conn->prepare('SELECT id FROM admins WHERE username=? OR email=? LIMIT 1');
        $stmt->bind_param('ss', $username, $email);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $error = 'Username or email already exists.';
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt2 = $conn->prepare('INSERT INTO admins (username, email, password) VALUES (?, ?, ?)');
            $stmt2->bind_param('sss', $username, $email, $hash);
            if ($stmt2->execute()) {
                $success = 'Admin account created! You can now <a href="admin_login.php">login</a>.';
            } else {
                $error = 'Registration failed.';
            }
            $stmt2->close();
        }
        $stmt->close();
    }
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Admin - Chicken Road</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body { background: #232834; margin: 0; }
        .register-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .register-box {
            background: #2c3240;
            border-radius: 12px;
            box-shadow: 0 4px 24px #0003;
            padding: 36px 32px 28px 32px;
            min-width: 340px;
        }
        .register-title {
            font-size: 2rem;
            color: #ffe066;
            font-weight: bold;
            margin-bottom: 18px;
            text-align: center;
        }
        .register-form label {
            color: #fff;
            font-size: 1.1rem;
            font-weight: 500;
        }
        .register-form input {
            width: 100%;
            padding: 10px 12px;
            margin: 8px 0 18px 0;
            border-radius: 6px;
            border: none;
            background: #383f4e;
            color: #fff;
            font-size: 1rem;
        }
        .register-btn {
            width: 100%;
            background: #e11d48;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 0;
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.2s;
        }
        .register-btn:hover { background: #b91c1c; }
        .register-error {
            color: #e11d48;
            font-weight: 600;
            margin-bottom: 10px;
            text-align: center;
        }
        .register-success {
            color: #22c55e;
            font-weight: 600;
            margin-bottom: 10px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="register-box">
            <div class="register-title">Register New Admin</div>
            <?php if ($error): ?>
                <div class="register-error"><?php echo $error; ?></div>
            <?php endif; ?>
            <?php if ($success): ?>
                <div class="register-success"><?php echo $success; ?></div>
            <?php endif; ?>
            <form class="register-form" method="post" autocomplete="off">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus>
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required>
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
                <label for="confirm">Confirm Password</label>
                <input type="password" id="confirm" name="confirm" required>
                <button class="register-btn" type="submit">Register</button>
            </form>
        </div>
    </div>
</body>
</html> 